@extends('admin.layouts.main')
@section('title')
    {{ __('page.BASIC_COMPANY_SETUP') }}
@endsection
@section('pre-title')
    {{ __('page.BASIC_COMPANY_SETUP') }}
@endsection
@section('page-title')
    <div class="row g-2 align-items-center">
        <div class="col">
            <!-- Page pre-title -->
            <div class="page-pretitle">
                <a href="{{ url('admin/dashboard') }}">{{ __('page.HOME') }}/</a>
                <a href="{{ url('admin/settings') }}">{{ __('page.SETTINGS') }}/</a>
                @yield('pre-title')
            </div>
            <h2 class="page-title">
                @yield('title')
            </h2>
        </div>
        <!-- Page title actions -->
        <div class="col-auto ms-auto d-print-none">
        </div>
    </div>
@endsection

@section('content')
    <section class="section m-2">
        <div id="addcompanySetup">
            <form action="{{ route('settings.company_setup') }}" method="post" id="createCompanySetupForm"
                enctype="multipart/form-data">
                @csrf
                <div class="row d-flex mb-3">
                    <div class="card admin_cards">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('page.COMPANY_DETAILS') }}
                                <i class="bi bi-info-circle-fill text-muted m-1 cursor-pointer" data-bs-toggle="tooltip"
                                    data-bs-placement="right" title="{{ __('page.COMPANY_DETAILS_HINT') }}"></i>
                            </h3>

                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12 form-group mandatory">
                                    <label for="company_name"
                                        class="col-sm-6 col-md-6 form-label">{{ __('page.COMPANY_NAME') }}<span
                                            class="text-danger">*</span></label>
                                    <input name="company_name" type="text" class="form-control" id="company_name"
                                        placeholder="{{ __('page.COMPANY_NAME') }}"
                                        value="{{ $settings['company_name'] ?? '' }}" />
                                    <span class="parsley-required"><strong id="company-name-error"></strong></span>
                                </div>
                                <div class="col-sm-12 form-group mandatory mt-3">
                                    <label for="company_email"
                                        class="col-sm-12 col-md-6 form-label mt-1">{{ __('page.EMAIL') }}<span
                                            class="text-danger">*</span></label>
                                    <input id="company_email" name="company_email" type="email" class="form-control"
                                        placeholder="{{ __('page.ENTER_EMAIL') }}"
                                        value="{{ $settings['company_email'] ?? '' }}" />
                                    <span class="parsley-required"><strong id="company-email-error"></strong></span>
                                </div>

                                <div class="col-sm-12 form-group mandatory mt-3">
                                    <label for="company_tel1"
                                        class="col-sm-12 col-md-6 form-label mt-1">{{ __('page.CONTACT_NUMBER') . ' 1' }}<span
                                            class="text-danger">*</span></label>
                                    <input id="company_tel1" name="company_tel1" type="text" class="form-control"
                                        placeholder="{{ __('page.CONTACT_NUMBER') . ' 1' }}" maxlength="16"
                                        onKeyDown="if(this.value.length==16 && event.keyCode!=8) return false;"
                                        value="{{ $settings['company_tel1'] ?? '' }}">
                                    <span class="parsley-required"><strong id="company-tel1-error"></strong></span>
                                </div>

                                <div class="col-sm-12">
                                    <label for="company_tel2"
                                        class="col-sm-12 col-md-6 form-label mt-3">{{ __('page.CONTACT_NUMBER') . ' 2' }}<span
                                            class="text-danger">*</span></label>
                                    <input id="company_tel2" name="company_tel2" type="text" class="form-control"
                                        placeholder="{{ __('page.CONTACT_NUMBER') . ' 2' }}" maxlength="16"
                                        onKeyDown="if(this.value.length==16 && event.keyCode!=8) return false;"
                                        value="{{ $settings['company_tel2'] ?? '' }}">
                                    <span class="parsley-required"><strong id="company-tel2-error"></strong></span>
                                </div>

                                <div class="col-sm-12">
                                    <label for="company_address"
                                        class="col-sm-12 col-md-6 form-label mt-3">{{ __('page.ADDRESS') }}<span
                                            class="text-danger">*</span></label>
                                    <textarea id="company_address" name="company_address" type="text" class="form-control"
                                        placeholder="{{ __('page.ENTER_ADDRESS') }}">{{ $settings['company_address'] ?? '' }}</textarea>
                                    <span class="parsley-required"><strong id="company-address-error"></strong></span>
                                </div>
                            </div>
                            <div class="col-12 mt-3 d-flex justify-content-end">
                                <button class="btn btn-primary me-1 mb-1" type="submit"
                                    name="submit">{{ __('page.SAVE') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection
